// Program to compare the effect of length of window on STFT
// Using Hamming window
//
//OS: windows 7
//Scilab: 5.5.2
//
clc;
close;
clear;

[y,Fs] = wavread('C:\Users\ACER\Desktop\Two.wav');
t=(0:length(y)-1)/Fs;
subplot(311)
plot(t,y)
xlabel('Time in seconds')
title('Original signal')
beg=5200; //Sample at which window is to be applied
N=900; // Length of window in samples
x=y(beg:beg+N-1);
whm = window('hm', N);
Ham_seg=x.*whm;  //Multiplying window with the signal
f_Ham=abs(fft(Ham_seg));  //Spectrum of the segment using Hamming window
l=length(f_Ham)/2;
f=(0:(l-1))*Fs/(2*l);  // Adjusting x axis to frequency 
subplot(3,1,2)
plot(f,f_Ham(1:l))
title('Spectrum using Hamming Window with N=900')
xlabel('Frequency')
ylabel('Magnitude')
////////////////////////////////
beg=5200; //Sample at which window is to be applied
N=300; // Length of window in samples
x=y(beg:beg+N-1);
whm = window('hm', N);
Ham_seg=x.*whm;  //Multiplying window with the signal
f_Ham=abs(fft(Ham_seg));  //Spectrum of the segment using Hamming window
l=length(f_Ham)/2;
f=(0:(l-1))*Fs/(2*l);  // Adjusting x axis to frequency 
subplot(3,1,3)
plot(f,f_Ham(1:l))
title('Spectrum using Hamming Window with N=300')
xlabel('Frequency')
ylabel('Magnitude')
